
/*
 * Editor client script for DB table sprectable
 * Created by http://editor.datatables.net/generator
 */

(function($){


$(document).ready(function() {



	var editor = new $.fn.dataTable.Editor( {
		ajax: 'php/table.sprectable.php',
		table: '#sprectable',
		fields: [
			{
				"label": "id:",
				"name": "id"
			},
			{
				"label": "tipo:",
				"name": "tipo"
			},
			{
				"label": "nombre:",
				"name": "nombre"
			},
			{
				"label": "identificacion:",
				"name": "identificacion"
			},
			{
				"label": "empresa:",
				"name": "empresa"
			},
			{
				"label": "cargo:",
				"name": "cargo"
			},
			{
				"label": "linea:",
				"name": "linea"
			},
			{
				"label": "lugar:",
				"name": "lugar"
			},
			{
				"label": "lugarespecifico:",
				"name": "lugarespecifico"
			},
			{
				"label": "probabilidad:",
				"name": "probabilidad"
			},
			{
				"label": "severidad:",
				"name": "severidad"
			},
			{
				"label": "riesgo:",
				"name": "riesgo"
			},
			{
				"label": "valoracion:",
				"name": "valoracion"
			},
			{
				"label": "reporte:",
				"name": "reporte"
			},
			{
				"label": "plan:",
				"name": "plan"
			},
			{
				"label": "timestamp:",
				"name": "timestamp"
			},
			{
				"label": "estado:",
				"name": "estado",
				"type": "select",
				"options": [
					"Abierto",
					" En proceso",
					" Cerrado"
				]
			},
			{
				"label": "seguimiento:",
				"name": "seguimiento"
			},
			{
				"label": "ticket:",
				"name": "ticket"
			},
		],
		
	} );

	var table = $('#sprectable').DataTable( {
		ajax: 'php/table.sprectable.php',
		columns: [
			{
				"data": "id"
			},
			{
				"data": "tipo"
			},
			{
				"data": "nombre"
			},
			{
				"data": "identificacion"
			},
			{
				"data": "empresa"
			},
			{
				"data": "cargo"
			},
			{
				"data": "linea"
			},
			{
				"data": "lugar"
			},
			{
				"data": "lugarespecifico"
			},
			{
				"data": "probabilidad"
			},
			{
				"data": "severidad"
			},
			{
				"data": "riesgo"
			},
			{
				"data": "valoracion"
			},
			{
				"data": "reporte"
			},
			{
				"data": "plan"
			},
			{
				"data": "timestamp"
			},
			{
				"data": "estado"
			},
			{
				"data": "seguimiento"
			},
			{
				"data": "ticket"
			}
		],
		select: true,
		lengthChange: false,
		

	} );

	new $.fn.dataTable.Buttons( table, [
		{ extend: "create", editor: editor },
		{ extend: "edit",   editor: editor },
		{ extend: "remove", editor: editor },
		{ extend: "excel", editor: editor },
		{ extend: "print", editor: editor }
	] );

	table.buttons().container()
		.appendTo( $('.col-sm-6:eq(0)', table.table().container() ) );

	
} 

);

}(jQuery));

