
/*
 * Editor client script for DB table login
 * Created by http://editor.datatables.net/generator
 */

(function($){

$(document).ready(function() {
	var editor = new $.fn.dataTable.Editor( {
		ajax: 'php/table.login.php',
		table: '#login',
		fields: [
			{
				"label": "login:",
				"name": "login"
			},
			{
				"label": "password:",
				"name": "password"
			},
			{
				"label": "administrador:",
				"name": "administrador",
				"type": "select",
				"options": [
					"administrador",
					" usuario"
				]
			}
		]
	} );

	var table = $('#login').DataTable( {
		ajax: 'php/table.login.php',
		columns: [
			{
				"data": "login"
			},
			{
				"data": "password"
			},
			{
				"data": "administrador"
			}
		],
		select: true,
		lengthChange: false,
		pageLength: 60
	} );

	new $.fn.dataTable.Buttons( table, [
		{ extend: "create", editor: editor },
		{ extend: "edit",   editor: editor },
		{ extend: "remove", editor: editor }
	] );

	table.buttons().container()
		.appendTo( $('.col-sm-6:eq(0)', table.table().container() ) );
} );

}(jQuery));

